<?php
require_once('fishnavbase.class.php');
class FishNavItem extends FishNavBase
{
	var $item = NULL;
	var $url = NULL;
	var $link = NULL;
	var $selected_link = NULL;
	var $unselected_link = NULL;
	var $displayed = TRUE;
	var $selected = FALSE;
	var $display_text = NULL;
	var $link_tag_text = NULL;

	function FishNavItem()
	{
		$args = func_get_args();
		$this->constructor($args);
	}

	function selected($newvalue=NULL)
	{
		if ($newvalue !== NULL)
			$this->selected = !empty($newvalue);
		elseif (gettype($this->selected) != 'boolean')
			$this->selected = !empty($this->selected);
		return $this->selected;
	}

	function selected_link()
	{
		if (empty($this->selected_link))
		{
			if (!empty($this->link))
				$this->selected_link = $this->link;
			elseif (!empty($this->unselected_link))
				$this->selected_link = $this->unselected_link;
			else
				$this->selected_link = $this->item;
		}
		return $this->selected_link;
	}

	function unselected_link()
	{
		if (empty($this->unselected_link))
		{
			if (!empty($this->link))
				$this->unselected_link = $this->link;
			elseif (!empty($this->selected_link))
				$this->unselected_link = $this->selected_link;
			else
				$this->unselected_link = $this->item;
		}
		return $this->unselected_link;
	}

	function displayed($newvalue=NULL)
	{
		if ($newvalue !== NULL)
			$this->displayed = !empty($newvalue);
		elseif (gettype($this->displayed) != 'boolean')
			$this->displayed = !empty($this->displayed);
		return $this->displayed;
	}

	function selected_link_tag($url,$link)
	{
		return $this->link_tag($url, $link, 'black');
	}

	function unselected_link_tag($url,$link)
	{
		return $this->link_tag($url, $link, 'red');
	}

	function link_tag($url=NULL,$link=NULL,$color='red')
	{
		if ($this->link_tag_text)
		{
			$cmd = '$link_tag_text = <<<EOT
'.$this->link_tag_text.'
EOT;
';
			eval($cmd);
			$output = $link_tag_text;
		}
		elseif ($url)
		{
			if (!$link)
				$link = basename($url);
			$output = <<<EOT
<a target="_top" href="$url" style="text-decoration:none;color:$color;">$link</a>
EOT;
		}
		elseif ($link)
		{
			$output = $link;
		}
		else
		{
			$output = '';
		}
		return $output;
	}

	function link()
	{
		if ($this->selected())
		{
			$output = $this->selected_link_tag(
				$this->url
				, $this->selected_link()
			);
		}
		else
		{
			$output = $this->unselected_link_tag(
				$this->url
				, $this->unselected_link()
			);
		}
		return $output;
	}

	function format_display()
	{
		$link = $this->link();
		if ($this->display_text)
		{
			$cmd = '$display_text = <<<EOT
'.$this->display_text.'
EOT;
';
			eval($cmd);
			$output = $display_text;
		}
		else
		{
			$output = <<<EOT

  <td nowrap align="left" valign="center"><b>$link</b></td>

EOT;
		}
		return $output;
	}

	function display()
	{
		return $this->displayed() ? $this->format_display() : '';
	}
}
?>
