<?php
class FishNavBase
{
	var $properties = NULL;

	function FishNavBase()
	{
		$args = func_get_args();
		$this->constructor($args);
	}

	function properties()
	{
		if ($this->properties === NULL)
		{
			$this->properties = array_keys(get_object_vars($this));
		}
		return $this->properties;
	}

	function constructor($args=NULL)
	{
		if (!is_array($args))
			return;
		foreach ($args as $arg)
		{
			if (is_array($arg))
			{
				$keys = array_intersect($this->properties(), array_keys($arg));
				foreach ($keys as $k)
				{
					$this->$k = $arg[$k];
				}
			}
		}
	}

	function selected($newvalue=NULL)
	{
		if ($newvalue !== NULL)
			$this->selected = !empty($newvalue);
		elseif (gettype($this->selected) != 'boolean')
			$this->selected = !empty($this->selected);
		return $this->selected;
	}

	function displayed($newvalue=NULL)
	{
		if ($newvalue !== NULL)
			$this->displayed = !empty($newvalue);
		elseif (gettype($this->displayed) != 'boolean')
			$this->displayed = !empty($this->displayed);
		return $this->displayed;
	}

	function link_tag($url=NULL,$link=NULL)
	{
		if ($url)
		{
			if (!$link)
				$link = basename($url);
			$output = <<<EOT
<a target="_top" href="$url" style="text-decoration:none;">$link</a>
EOT;
		}
		elseif ($link)
		{
			$output = $link;
		}
		else
		{
			$output = '';
		}
		return $output;
	}

	function link()
	{
		$link = $this->selected() ? $this->selected_link : $this->unselected_link;
		$link = empty($link) ? $this->item : $link;
		return $this->link_tag($this->url, $link);
	}

	function format_display()
	{
		$link = $this->link();
		$output = <<<EOT
  <td align="left" valign="center"><b>$link</b></td>
EOT;
		return $output;
	}

	function display()
	{
		return $this->displayed() ? $this->format_display() : '';
	}
}
?>
