<?php
require_once('fishnavitem.class.php');
require_once('fishargs.class.php');

class FishNav extends FishNavBase
{
	var $items = array();
	var $item_names = array();
	var $values = array();
	var $selected_item = NULL;
	var $default_class = 'FishNavItem';
	var $begin_text = NULL;
	var $end_text = NULL;
	var $displayed = TRUE;

	function FishNav()
	{
		$args = func_get_args();
		$this->constructor($args);
	}

	function items($newitems=NULL)
	{
		if (!is_array($this->items))
		{
			$this->items = array();
		}
		if (is_array($newitems))
		{
			$this->items = array();
			foreach ($newitems as $item)
			{
				$this->add_item($item);
			}
		}
		return $this->items;
	}

	function item_names($newname=NULL)
	{
		if (!is_array($this->item_names))
		{
			$this->item_names = array();
		}
		if ($newname !== NULL)
		{
			$this->item_names[] = $newname;
		}
		return $this->item_names;
	}

	function add_item()
	{
		static $_defaults = array(
			'class' => NULL
			, 'item' => NULL
			, 'url' => NULL
			, 'link' => NULL
		);
		static $_simple = array('item','url','link','class');
		$args = func_get_args();
		$p = FishArgs::parse_arguments($args, $_simple, $_defaults);
		$i = count($this->items());
		if (empty($p['item']))
			$p['item'] = $i;
		if (empty($p['class']))
		{
			$p['class'] = $this->default_class;
		}
		elseif (!class_exists($p['class']))
		{
			$this->errors[] = "Item class '{$p['class']}' does not exist";
			return FALSE;
		}
		$this->items[$p['item']] =& new $p['class']($p);
		if (!is_a($this->items[$p['item']], 'FishNavItem'))
		{
			unset($this->items[$p['item']]);
			$this->errors[] = "Item class '{$p['class']}' is not a child of FishNavItem";
			return FALSE;
		}
		$this->item_names($p['item']);
	}

	function select($i=NULL)
	{
		if ($this->selected_item)
		{
			$this->items[$this->selected_item]->selected(FALSE);
		}
		if (in_array($i, $this->item_names()))
		{
			$item = $i;
		}
		else
		{
			if (!isset($this->item_names[$i]))
				$i = 0;
			$item = $this->item_names[$i];
		}
		$this->items[$item]->displayed(TRUE);
		$this->items[$item]->selected(TRUE);
		$this->selected_item = $item;
	}

	function format_begin_display()
	{
		if ($this->begin_text)
		{
			$cmd = '$begin_text = <<<EOT
'.$this->begin_text.'
EOT;
';
			eval($cmd);
			$output = $begin_text;
		}
		else
		{
			$output = <<<EOT

<table>
 <tr>

EOT;
		}
		return $output;
	}

	function format_end_display()
	{
		if ($this->end_text)
		{
			$cmd = '$end_text = <<<EOT
'.$this->end_text.'
EOT;
';
			eval($cmd);
			$output = $end_text;
		}
		else
		{
			$output = <<<EOT

 </tr>
</table>

EOT;
		}
		return $output;
	}

	function display()
	{
		if ($this->displayed)
		{
			$output = $this->format_begin_display();
			foreach ($this->item_names() as $item)
			{
				$output .= $this->items[$item]->display();
			}
			$output .= $this->format_end_display();
			return $output;
		}
	}
}
?>
