<?php

/*
** Fishlib - a collection of utilities for db-driven applications in PHP
** Copyright (C) 2002  LTWD, LLC DBA The Madfish Group
**
** This library is free software; you can redistribute it and/or
** modify it under the terms of the GNU Lesser General Public
** License as published by the Free Software Foundation; either
** version 2.1 of the License, or (at your option) any later version.
**
** This library is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** Lesser General Public License for more details.
**
** You should have received a copy of the GNU Lesser General Public
** License along with this library; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

class FishDSN
{
	function db_dsnlist()
	{
		static $_defaults = array(
			'application' => 'default'
			, 'dsnpath' => NULL
			, 'phptype' => NULL
			, 'dbsyntax' => NULL
			, 'username' => NULL
			, 'password' => NULL
			, 'protocol' => NULL
			, 'hostspec' => NULL
			, 'port' => NULL
			, 'socket' => NULL
			, 'database' => NULL
		);
		static $_simple = array('application','username','password','database');
		$p = func_get_args();
		$p = FishArgs::parse_arguments($p, $_simple, $_defaults);
		$dsnpath = FishUtil::array_key_value($p, 'dsnpath');
		if ($dsnpath === NULL)
			$dsnpath = dirname(__FILE__);
		$dsnpath = realpath($dsnpath);
		if (empty($dsnpath))
			$dsnpath = '.';
		elseif (!is_dir($dsnpath))
			$dsnpath = dirname($dsnpath);

		static $dsnlist = NULL;

		if ($dsnlist === NULL)
		{
			$dsn_file = "{$dsnpath}/dsn.ini";
			if (!file_exists($dsn_file))
			{
				user_error("DSN file '$dsn_file' not found", E_USER_WARNING);
				return FALSE;
			}
			$dsnlist = parse_ini_file($dsn_file, TRUE);
			foreach ($dsnlist as $k => $a)
			{
				if ($k != 'default')
					$a = array_merge($dsnlist['default'], $a);
				$dsnlist[$k] = array_merge($_defaults, $a);
			}
		}


		// remove NULL values to not override entries from dsn
		$p = array_diff($p, array_filter($p,'is_null'));
		if (isset($p['application']) and isset($dsnlist[$p['application']]))
		{
			$dsn = array_merge($dsnlist[$p['application']],$p);
		}
		else
		{
			$dsn = array_merge($dsnlist['default'],$p);
		}
		// $dsn['pconnect'] = false;
		unset($dsn['_defaults']);
		unset($dsn['_simple']);
		return $dsn;
	}
}
?>
