<?php

/*
** Fishlib - a collection of utilities for db-driven applications in PHP
** Copyright (C) 2002  LTWD, LLC DBA The Madfish Group
**
** This library is free software; you can redistribute it and/or
** modify it under the terms of the GNU Lesser General Public
** License as published by the Free Software Foundation; either
** version 2.1 of the License, or (at your option) any later version.
**
** This library is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** Lesser General Public License for more details.
**
** You should have received a copy of the GNU Lesser General Public
** License along with this library; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

require_once('fishutil.class.php');
class FishArgs
{
	function parse_arguments($args,&$simple,&$defaults)
	{
		$args = (array)$args;
		$simple = (array)$simple;
		$defaults = (array)$defaults;

		$key = NULL;
		$result = $defaults;
		$result['_defaults'] = $defaults;
		$result['_simple'] = $simple;

		$i = 0;

		$sc = count($simple);

		foreach ($args as $arg)
		{
			if ($arg === NULL || (is_array($arg) && count($arg) == 0))
			{
				// do nothing
			}
			elseif (is_object($arg))	
			{
				$result = array_merge($result, get_object_vars($arg));
			}
			elseif (FishUtil::is_assoc($arg))	
			{
				$result = array_merge($result, $arg);
			}
			else
			{
				if ($i < $sc)
				{
					$key = $simple[$i++];
					if (!empty($arg) 
						|| !isset($result[$key]) 
						|| ( is_bool($arg) && isset($defaults[$key]) && is_bool($defaults[$key]) )
					)
					{
						$result[$key] = $arg;
					}
				}
				else
				{
					if ($key === NULL)
					{
						user_error("Argument '$arg' was passed with no available target - aborting...\n", E_USER_ERROR);
					}
					if (isset($result[$key]))
					{
						if (!is_array($result[$key]))
						{
							$result[$key] = array($result[$key]);
						}
						$result[$key][] = $arg;
					}
					else
					{
						$result[$key] = $arg;
					}
				}
			}
		}
		$defaults = array_merge($defaults, $result['_defaults']);
		$simple = $result['_simple'];
		return $result;
	}

	function defaults(&$defaults, $args='',$default='')
	{
		if (is_string($args) && !empty($args))
		{
			return FishUtil::array_key_value($defaults,$args,$default);
		}

		if (is_array($args) || is_object($args))
		{
			$defaults = array_merge($defaults, (array)$args);
		}
		return $defaults;
	}

	function set_defaults(&$old_defaults, &$args)
	{
		if (FishUtil::is_assoc($old_defaults) and FishUtil::is_assoc($args))
		{
			$defaults = array();
			extract((array)FishUtil::array_key_remove($args, 'defaults', array()));
			if (count($defaults) > 0 && FishUtil::is_assoc($defaults))
			{
				$old_defaults = array_merge((array)$old_defaults, $defaults);
			}
		}
		return $old_defaults;
	}

}
?>
