<?php

/*
** Fishlib - a collection of utilities for db-driven applications in PHP
** Copyright (C) 2002  LTWD, LLC DBA The Madfish Group
**
** This library is free software; you can redistribute it and/or
** modify it under the terms of the GNU Lesser General Public
** License as published by the Free Software Foundation; either
** version 2.1 of the License, or (at your option) any later version.
**
** This library is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** Lesser General Public License for more details.
**
** You should have received a copy of the GNU Lesser General Public
** License along with this library; if not, write to the Free Software
** Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

class FishAddress
{
	var $state;
	var $country;

	function countries($check=null)
	{
		static $countries = array(
			'USA' => 'USA'
			,'Canada' => 'Canada'
			,'Afghanistan' => 'Afghanistan'
			,'Albania' => 'Albania'
			,'Algeria' => 'Algeria'
			,'Andorra' => 'Andorra'
			,'Angola' => 'Angola'
			,'Anguilla' => 'Anguilla'
			,'Antarctica' => 'Antarctica'
			,'Antigua & Barbuda' => 'Antigua & Barbuda'
			,'Argentina' => 'Argentina'
			,'Armenia' => 'Armenia'
			,'Aruba' => 'Aruba'
			,'Australia' => 'Australia'
			,'Austria' => 'Austria'
			,'Azerbaijan' => 'Azerbaijan'
			,'Bahamas' => 'Bahamas'
			,'Bahrain' => 'Bahrain'
			,'Bangladesh' => 'Bangladesh'
			,'Barbados' => 'Barbados'
			,'Belarus' => 'Belarus'
			,'Belgium' => 'Belgium'
			,'Belize' => 'Belize'
			,'Benin' => 'Benin'
			,'Bermuda' => 'Bermuda'
			,'Bhutan' => 'Bhutan'
			,'Bolivia' => 'Bolivia'
			,'Bosnia & Herzegovina' => 'Bosnia & Herzegovina'
			,'Botswana' => 'Botswana'
			,'Bouvet Island' => 'Bouvet Island'
			,'Brazil' => 'Brazil'
			,'British Indian Ocean Territ' => 'British Indian Ocean Territ'
			,'Brunei' => 'Brunei'
			,'Bulgaria' => 'Bulgaria'
			,'Burkina Faso' => 'Burkina Faso'
			,'Burundi' => 'Burundi'
			,'Cambodia' => 'Cambodia'
			,'Cameroon' => 'Cameroon'
			,'Cape Verde' => 'Cape Verde'
			,'Cayman Islands' => 'Cayman Islands'
			,'Central African Rep.' => 'Central African Rep.'
			,'Chad' => 'Chad'
			,'Chile' => 'Chile'
			,'China' => 'China'
			,'Christmas Island' => 'Christmas Island'
			,'Cocos (Keeling) Islands' => 'Cocos (Keeling) Islands'
			,'Colombia' => 'Colombia'
			,'Comoros' => 'Comoros'
			,'Congo (Dem. Rep.)' => 'Congo (Dem. Rep.)'
			,'Congo (Rep.)' => 'Congo (Rep.)'
			,'Cook Islands' => 'Cook Islands'
			,'Costa Rica' => 'Costa Rica'
			,"Cote d'Ivoire" => "Cote d'Ivoire"
			,'Croatia' => 'Croatia'
			,'Cuba' => 'Cuba'
			,'Cyprus' => 'Cyprus'
			,'Czech Republic' => 'Czech Republic'
			,'Denmark' => 'Denmark'
			,'Djibouti' => 'Djibouti'
			,'Dominica' => 'Dominica'
			,'Dominican Republic' => 'Dominican Republic'
			,'East Timor' => 'East Timor'
			,'Ecuador' => 'Ecuador'
			,'Egypt' => 'Egypt'
			,'El Salvador' => 'El Salvador'
			,'Equatorial Guinea' => 'Equatorial Guinea'
			,'Eritrea' => 'Eritrea'
			,'Estonia' => 'Estonia'
			,'Ethiopia' => 'Ethiopia'
			,'Faeroe Islands' => 'Faeroe Islands'
			,'Falkland Islands' => 'Falkland Islands'
			,'Fiji' => 'Fiji'
			,'Finland' => 'Finland'
			,'France' => 'France'
			,'France, Metropolitan' => 'France, Metropolitan'
			,'French Guiana' => 'French Guiana'
			,'French Polynesia' => 'French Polynesia'
			,'French Southern & Antarctic' => 'French Southern & Antarctic'
			,'Gabon' => 'Gabon'
			,'Gambia' => 'Gambia'
			,'Georgia' => 'Georgia'
			,'Germany' => 'Germany'
			,'Ghana' => 'Ghana'
			,'Gibraltar' => 'Gibraltar'
			,'Greece' => 'Greece'
			,'Greenland' => 'Greenland'
			,'Grenada' => 'Grenada'
			,'Guadeloupe' => 'Guadeloupe'
			,'Guam' => 'Guam'
			,'Guatemala' => 'Guatemala'
			,'Guinea' => 'Guinea'
			,'Guinea-Bissau' => 'Guinea-Bissau'
			,'Guyana' => 'Guyana'
			,'Haiti' => 'Haiti'
			,'Heard Island & McDonald Isl' => 'Heard Island & McDonald Isl'
			,'Honduras' => 'Honduras'
			,'Hungary' => 'Hungary'
			,'Iceland' => 'Iceland'
			,'India' => 'India'
			,'Indonesia' => 'Indonesia'
			,'Iran' => 'Iran'
			,'Iraq' => 'Iraq'
			,'Ireland' => 'Ireland'
			,'Israel' => 'Israel'
			,'Italy' => 'Italy'
			,'Jamaica' => 'Jamaica'
			,'Japan' => 'Japan'
			,'Jordan' => 'Jordan'
			,'Kazakhstan' => 'Kazakhstan'
			,'Kenya' => 'Kenya'
			,'Kirgizstan' => 'Kirgizstan'
			,'Kiribati' => 'Kiribati'
			,'Korea' => 'Korea'
			,'Kuwait' => 'Kuwait'
			,'Laos' => 'Laos'
			,'Latvia' => 'Latvia'
			,'Lebanon' => 'Lebanon'
			,'Lesotho' => 'Lesotho'
			,'Liberia' => 'Liberia'
			,'Libya' => 'Libya'
			,'Liechtenstein' => 'Liechtenstein'
			,'Lithuania' => 'Lithuania'
			,'Luxembourg' => 'Luxembourg'
			,'Macao' => 'Macao'
			,'Macedonia' => 'Macedonia'
			,'Madagascar' => 'Madagascar'
			,'Malawi' => 'Malawi'
			,'Malaysia' => 'Malaysia'
			,'Maldives' => 'Maldives'
			,'Mali' => 'Mali'
			,'Malta' => 'Malta'
			,'Marshall Islands' => 'Marshall Islands'
			,'Martinique' => 'Martinique'
			,'Mauritania' => 'Mauritania'
			,'Mauritius' => 'Mauritius'
			,'Mayotte' => 'Mayotte'
			,'Mexico' => 'Mexico'
			,'Micronesia' => 'Micronesia'
			,'Moldova' => 'Moldova'
			,'Monaco' => 'Monaco'
			,'Mongolia' => 'Mongolia'
			,'Montserrat' => 'Montserrat'
			,'Morocco' => 'Morocco'
			,'Mozambique' => 'Mozambique'
			,'Burma' => 'Burma'
			,'Namibia' => 'Namibia'
			,'Nauru' => 'Nauru'
			,'Nepal' => 'Nepal'
			,'Netherlands' => 'Netherlands'
			,'Netherlands Antilles' => 'Netherlands Antilles'
			,'New Caledonia' => 'New Caledonia'
			,'New Zealand' => 'New Zealand'
			,'Nicaragua' => 'Nicaragua'
			,'Niger' => 'Niger'
			,'Nigeria' => 'Nigeria'
			,'Niue' => 'Niue'
			,'Norfolk Island' => 'Norfolk Island'
			,'North Korea' => 'North Korea'
			,'Northern Mariana Islands' => 'Northern Mariana Islands'
			,'Norway' => 'Norway'
			,'Oman' => 'Oman'
			,'Pakistan' => 'Pakistan'
			,'Palau' => 'Palau'
			,'Palestine' => 'Palestine'
			,'Panama' => 'Panama'
			,'Papua New Guinea' => 'Papua New Guinea'
			,'Paraguay' => 'Paraguay'
			,'Peru' => 'Peru'
			,'Philippines' => 'Philippines'
			,'Pitcairn' => 'Pitcairn'
			,'Poland' => 'Poland'
			,'Portugal' => 'Portugal'
			,'Puerto Rico' => 'Puerto Rico'
			,'Qatar' => 'Qatar'
			,'Reunion' => 'Reunion'
			,'Romania' => 'Romania'
			,'Russia' => 'Russia'
			,'Rwanda' => 'Rwanda'
			,'Samoa (American)' => 'Samoa (American)'
			,'Samoa (Western)' => 'Samoa (Western)'
			,'San Marino' => 'San Marino'
			,'Sao Tome & Principe' => 'Sao Tome & Principe'
			,'Saudi Arabia' => 'Saudi Arabia'
			,'Senegal' => 'Senegal'
			,'Seychelles' => 'Seychelles'
			,'Sierra Leone' => 'Sierra Leone'
			,'Singapore' => 'Singapore'
			,'Slovakia' => 'Slovakia'
			,'Slovenia' => 'Slovenia'
			,'Solomon Islands' => 'Solomon Islands'
			,'Somalia' => 'Somalia'
			,'South Africa' => 'South Africa'
			,'South Georgia & the South S' => 'South Georgia & the South S'
			,'Spain' => 'Spain'
			,'Sri Lanka' => 'Sri Lanka'
			,'St Helena' => 'St Helena'
			,'St Kitts & Nevis' => 'St Kitts & Nevis'
			,'St Lucia' => 'St Lucia'
			,'St Pierre & Miquelon' => 'St Pierre & Miquelon'
			,'St Vincent' => 'St Vincent'
			,'Sudan' => 'Sudan'
			,'Suriname' => 'Suriname'
			,'Svalbard & Jan Mayen' => 'Svalbard & Jan Mayen'
			,'Swaziland' => 'Swaziland'
			,'Sweden' => 'Sweden'
			,'Switzerland' => 'Switzerland'
			,'Syria' => 'Syria'
			,'Taiwan' => 'Taiwan'
			,'Tajikistan' => 'Tajikistan'
			,'Tanzania' => 'Tanzania'
			,'Thailand' => 'Thailand'
			,'Togo' => 'Togo'
			,'Tokelau' => 'Tokelau'
			,'Tonga' => 'Tonga'
			,'Trinidad & Tobago' => 'Trinidad & Tobago'
			,'Tunisia' => 'Tunisia'
			,'Turkey' => 'Turkey'
			,'Turkmenistan' => 'Turkmenistan'
			,'Turks & Caicos Is' => 'Turks & Caicos Is'
			,'Tuvalu' => 'Tuvalu'
			,'Uganda' => 'Uganda'
			,'Ukraine' => 'Ukraine'
			,'United Arab Emirates' => 'United Arab Emirates'
			,'United Kingdom' => 'United Kingdom'
			,'Uruguay' => 'Uruguay'
			,'Uzbekistan' => 'Uzbekistan'
			,'Vanuatu' => 'Vanuatu'
			,'Vatican City' => 'Vatican City'
			,'Venezuela' => 'Venezuela'
			,'Vietnam' => 'Vietnam'
			,'Virgin Islands (UK)' => 'Virgin Islands (UK)'
			,'Virgin Islands (US)' => 'Virgin Islands (US)'
			,'Wallis & Futuna' => 'Wallis & Futuna'
			,'Western Sahara' => 'Western Sahara'
			,'Yemen' => 'Yemen'
			,'Yugoslavia' => 'Yugoslavia'
			,'Zambia' => 'Zambia'
			,'Zimbabwe' => 'Zimbabwe'
		);

		if ($check === null)
			return $countries;
		if (empty($countries[$check]))
			return false;
		return $countries[$check];
	}

	function provinces($check=null)
	{
		static $provinces = array(
			'' => ''
			, 'AB' => 'Alberta'
			, 'BC' => 'British Columbia'
			, 'MB' => 'Manitoba'
			, 'NB' => 'New Brunswick'
			, 'NL' => 'Newfoundland/Labrador'
			, 'NT' => 'Northwest Territories'
			, 'NS' => 'Nova Scotia'
			, 'NU' => 'Nunavut'
			, 'ON' => 'Ontario'
			, 'PE' => 'Prince Edward Island'
			, 'QC' => 'Quebec'
			, 'SK' => 'Saskatchewan'
			, 'YT' => 'Yukon'
		);
		if ($check === null)
			return $provinces;
		if (!array_key_exists($check,$provinces))
			return false;
		return $provinces[$check];
	}


	function states($check=null)
	{
		static $states = array(
			'' => ''
			, 'AL' => 'Alabama'
			, 'AK' => 'Alaska'
			, 'AZ' => 'Arizona'
			, 'AR' => 'Arkansas'
			, 'CA' => 'California'
			, 'CO' => 'Colorado'
			, 'CT' => 'Connecticut'
			, 'DE' => 'Delaware'
			, 'DC' => 'District Of Columbia'
			, 'FL' => 'Florida'
			, 'GA' => 'Georgia'
			, 'HI' => 'Hawaii'
			, 'ID' => 'Idaho'
			, 'IL' => 'Illinois'
			, 'IN' => 'Indiana'
			, 'IA' => 'Iowa'
			, 'KS' => 'Kansas'
			, 'KY' => 'Kentucky'
			, 'LA' => 'Louisiana'
			, 'ME' => 'Maine'
			, 'MD' => 'Maryland'
			, 'MA' => 'Massachusetts'
			, 'MI' => 'Michigan'
			, 'MN' => 'Minnesota'
			, 'MS' => 'Mississippi'
			, 'MO' => 'Missouri'
			, 'MT' => 'Montana'
			, 'NE' => 'Nebraska'
			, 'NV' => 'Nevada'
			, 'NH' => 'New Hampshire'
			, 'NJ' => 'New Jersey'
			, 'NM' => 'New Mexico'
			, 'NY' => 'New York'
			, 'NC' => 'North Carolina'
			, 'ND' => 'North Dakota'
			, 'OH' => 'Ohio'
			, 'OK' => 'Oklahoma'
			, 'OR' => 'Oregon'
			, 'PA' => 'Pennsylvania'
			, 'PR' => 'Puerto Rico'
			, 'RI' => 'Rhode Island'
			, 'SC' => 'South Carolina'
			, 'SD' => 'South Dakota'
			, 'TN' => 'Tennessee'
			, 'TX' => 'Texas'
			, 'UT' => 'Utah'
			, 'VT' => 'Vermont'
			, 'VA' => 'Virginia'
			, 'WA' => 'Washington'
			, 'WV' => 'West Virginia'
			, 'WI' => 'Wisconsin'
			, 'WY' => 'Wyoming'
			, 'AS' => 'American Samoa'
			, 'AA' => 'Armed Forces Americas'
			, 'AE' => 'Armed Forces Europe'
			, 'AP' => 'Armed Forces Pacific'
			, 'GU' => 'Guam'
			, 'MH' => 'Marshall Islands'
			, 'FM' => 'Micronesia'
			, 'MP' => 'No. Mariana Islands'
			, 'PW' => 'Palau'
			, 'VI' => 'Virgin Islands'
		);
		if ($check === null)
			return $states;
		if (!array_key_exists($check, $states))
			return false;
		return $states[$check];
	}

	function state_select_list($matchstate=NULL,$name='state')
	{
		if ($matchstate === NULL && !empty($this) && !empty($this->state))
			$matchstate = $this->state;
		$matchstate = trim($matchstate);
		$output = <<<EOT
   <select name="$name" onChange="javascript:add_select_option(this,'Enter new state or province name:');">
    <option value="">(USA/Canada)</option>

EOT;
		$states = FishAddress::states();
		$umatchstate = strtoupper($matchstate);
		$was_selected = FALSE;
		foreach ($states as $state => $statename)
		{
			if (empty($state))
				continue;
			$selected = $umatchstate == $state ? 'selected' : '';
			$was_selected = ($was_selected || $selected);
			$output .= <<<EOT
    <option value="$state" $selected>$statename</option>

EOT;
		}
		$provinces = FishAddress::provinces();
		$provinces[key($provinces)] = ' -- Canada -- ';
		foreach ($provinces as $province => $provincename)
		{
			if (empty($province))
				continue;
			$selected = $umatchstate == $province ? 'selected' : '';
			$was_selected = ($was_selected || $selected);
			$output .= <<<EOT
    <option value="$province" $selected>$provincename</option>

EOT;
		}
		if ($matchstate && !$was_selected)
		{
			$output .= <<<EOT
    <option value="$matchstate" selected>$matchstate</option>

EOT;
		}
		$output .= <<<EOT
    <option value="-1">Other...</option>
   </select>

EOT;
//   <span style="font-size:10px;">
//    <br/>
//    Other: <input name="other_{$name}" value="$other_state" type="text" size="20" maxlength="32">
//   </span>
		return $output;
	}

	function country_select_list($matchcountry=NULL,$name='country')
	{
		if ($matchcountry === NULL && !empty($this) && !empty($this->country))
			$matchcountry = $this->country;
		$matchcountry = trim($matchcountry);
		$output = <<<EOT
   <select name="$name" onChange="javascript:add_select_option(this,'Enter new country name:');">
    <option value=""></option>

EOT;
		$countries = FishAddress::countries();
		$was_selected = FALSE;
		$lcountries = array_map('strtolower', $countries);
		$lmatchcountry = strtolower($matchcountry);
		foreach ($countries as $k => $country)
		{
			if (empty($country))
				continue;
			$selected = $lmatchcountry == $lcountries[$k] ? 'selected' : '';
			$was_selected = ($was_selected || $selected);
			$output .= <<<EOT
    <option value="$country" $selected>$country</option>

EOT;
		}
		if ($matchcountry && !$was_selected)
		{
			$output .= <<<EOT
    <option value="$matchcountry" selected>$matchcountry</option>

EOT;
		}
		$output .= <<<EOT
    <option value="-1">Other...</option>
   </select>

EOT;
//		$other_country = $was_selected ? '' : $matchcountry;
//   <span style="font-size:10px;">
//    <br/>
//    Other: <input name="other_{$name}" value="$other_country" type="text" size="20" maxlength="32">
//   </span>
		return $output;
	}

	function location($row)
	{
		if (is_object($row))
		{
			error_log(__FUNCTION__.':Fix this reference - use FishAddress::object_location');
			return FishAddress::object_location($row);
		}
		$location = empty($row['city']) ? '' : $row['city'];
		if (!empty($row['state']))
		{
			if (!empty($location))
				$location .= ', ';
			$location .= $row['state'];
		}
		if (!empty($row['country']) && $row['country'] != 'USA')
		{
			if (!empty($location))
				$location .= ', ';
			$location .= $row['country'];
		}
		return $location;
	}

	function object_location($o)
	{
		$location = empty($o->city) ? '' : $o->city;
		if (!empty($o->state))
		{
			if (!empty($location))
				$location .= ', ';
			$location .= $o->state;
		}
		if (!empty($o->country) && $o->country != 'USA')
		{
			if (!empty($location))
				$location .= ', ';
			$location .= $o->country;
		}
		return $location;
	}

	function add_select_option_javascript()
	{
		$func = FishAddress::add_select_option_javascript_function();
		$output = <<<EOT
<script language="javascript">
$func
</script>

EOT;
		return $output;
	}

	function add_select_option_javascript_function()
	{
		$output = <<<EOT
function add_select_option(f,message)
{
	if (!message)
	{
		message = 'Enter new value:';
	}
	if (f.options[f.selectedIndex].value == -1)
	{
		result = prompt(message);
		if (result)
		{
			f.options[f.options.length] = new Option(result,result,false,true);
		}
	}
}

EOT;
		return $output;
	}
}
?>
